<?php

/**
 * This file is part of the Prestashop Shipping module of DPD Nederland B.V.
 *
 * Copyright (C) 2017  DPD Nederland B.V.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

class dpdconnectOneStepParcelshopModuleFrontController extends ModuleFrontController
{
    public function initContent()
    {
        if (Tools::getValue('method') === 'setParcelShop') {
            if (Tools::getValue('parcelId')) {
                $parcelId = Tools::getValue('parcelId');
                $this->context->cookie->parcelId = $parcelId;
            }

            if (Tools::getValue('parcelshopData')) {
                $parcelshopData = Tools::getValue('parcelshopData');
                $parcelshopData = json_decode($parcelshopData, true);
                $allowedKeys = ['parcelShopId', 'company', 'street', 'houseNo', 'state', 'isoAlpha2', 'zipCode', 'city', 'country'];
                $parcelshopData = array_intersect_key($parcelshopData, array_flip($allowedKeys));

                $this->context->cookie->parcelshopData = json_encode($parcelshopData);
            }
        }

        die($this->context->cookie->parcelshopData);
    }
}
